import { jsx, jsxs } from "react/jsx-runtime";
import { D as DeleteModal } from "./delete-modal-CTUf4WRn.js";
import { A as Accordion, a as AccordionItem, b as AccordionTrigger, c as AccordionContent } from "./accordion-DjZKTuzo.js";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { usePage, Link } from "@inertiajs/react";
import { format, parseISO } from "date-fns";
import { Plus, Calendar, Clock, Users, Trash2 } from "lucide-react";
import { Renderer } from "richtor";
/* empty css                 */
import LiveClassForm from "./live-class-form-Cs-aHLwp.js";
import LiveClassStatus from "./live-class-status-B5j35Hn2.js";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "react";
import "@radix-ui/react-accordion";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./datetime-picker-vvicdyd7.js";
import "react-day-picker";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./use-lang-44ndmTOc.js";
import "./input-error-CBKwRgzN.js";
import "./input-BPdrsFAc.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
const zoomIsEnabled = (config) => {
  const { zoom_account_email, zoom_account_id, zoom_client_id, zoom_client_secret } = config;
  return Boolean(zoom_account_email && zoom_account_id && zoom_client_id && zoom_client_secret);
};
const LiveClass = () => {
  const { props } = usePage();
  const { translate } = props;
  const { dashboard, button } = translate;
  const { course, zoomConfig } = props;
  const isZoomEnabled = zoomIsEnabled(zoomConfig);
  const liveClasses = course.live_classes || [];
  return /* @__PURE__ */ jsx(Card, { className: "container p-4 sm:p-6", children: /* @__PURE__ */ jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
      /* @__PURE__ */ jsx("h2", { className: "text-xl font-bold", children: dashboard.live_classes }),
      /* @__PURE__ */ jsx("div", { className: "flex items-center gap-3", children: isZoomEnabled ? /* @__PURE__ */ jsx(
        LiveClassForm,
        {
          courseId: course.id,
          title: button.schedule_class,
          handler: /* @__PURE__ */ jsxs(Button, { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsx(Plus, { className: "h-4 w-4" }),
            button.schedule_class
          ] })
        }
      ) : /* @__PURE__ */ jsxs(Button, { disabled: true, className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsx(Plus, { className: "h-4 w-4" }),
        button.schedule_class
      ] }) })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "space-y-4", children: liveClasses.length === 0 ? /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsxs("p", { className: "bg-destructive/5 dark:bg-destructive/30 rounded-lg p-3 text-center text-sm text-red-500", children: [
        dashboard.zoom_not_enabled_message,
        " ",
        /* @__PURE__ */ jsx(Link, { href: route("settings.live-class"), className: "text-blue-500 hover:underline", children: dashboard.enable_zoom })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "p-8 text-center", children: [
        /* @__PURE__ */ jsx(Calendar, { className: "mx-auto mb-4 h-12 w-12 text-gray-400" }),
        /* @__PURE__ */ jsx("h3", { className: "mb-2 text-lg font-medium", children: dashboard.no_live_classes_scheduled }),
        /* @__PURE__ */ jsx("p", { className: "text-gray-500", children: dashboard.schedule_first_live_class })
      ] })
    ] }) : liveClasses.map((liveClass) => {
      var _a, _b;
      return /* @__PURE__ */ jsxs(Card, { className: "p-6", children: [
        /* @__PURE__ */ jsxs("div", { className: "flex flex-col items-start justify-between gap-6 md:flex-row", children: [
          /* @__PURE__ */ jsxs("div", { className: "flex-1", children: [
            /* @__PURE__ */ jsx("h3", { className: "mb-4 text-lg font-semibold", children: liveClass.class_topic }),
            /* @__PURE__ */ jsxs("div", { className: "text-muted-foreground mb-4 space-y-3 text-sm", children: [
              /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsx(Calendar, { className: "h-4 w-4" }),
                /* @__PURE__ */ jsx("span", { children: format(parseISO(liveClass.class_date_and_time), "PPP") })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsx(Clock, { className: "h-4 w-4" }),
                /* @__PURE__ */ jsx("span", { children: format(parseISO(liveClass.class_date_and_time), "p") })
              ] }),
              /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsx(Users, { className: "h-4 w-4" }),
                /* @__PURE__ */ jsxs("span", { children: [
                  button.instructor,
                  ": ",
                  ((_b = (_a = course.instructor) == null ? void 0 : _a.user) == null ? void 0 : _b.name) || "Unknown"
                ] })
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxs("div", { className: "flex flex-col gap-2", children: [
            /* @__PURE__ */ jsx(LiveClassStatus, { courseId: course.id, liveClass, zoomConfig }),
            /* @__PURE__ */ jsx(
              DeleteModal,
              {
                routePath: route("live-class.destroy", liveClass.id),
                actionComponent: /* @__PURE__ */ jsxs(Button, { size: "sm", variant: "outline", className: "flex w-full items-center gap-1 text-red-600 hover:text-red-700", children: [
                  /* @__PURE__ */ jsx(Trash2, { className: "h-3 w-3" }),
                  button.delete_class
                ] })
              }
            )
          ] })
        ] }),
        liveClass.class_note && /* @__PURE__ */ jsx(Accordion, { type: "single", collapsible: true, className: "mt-4 w-full", children: /* @__PURE__ */ jsxs(AccordionItem, { value: "item-1", className: "bg-muted overflow-hidden rounded-lg border-none", children: [
          /* @__PURE__ */ jsx(AccordionTrigger, { className: "[&[data-state=open]]:!bg-secondary-lighter px-4 py-2 text-base font-medium hover:no-underline", children: button.class_note }),
          /* @__PURE__ */ jsx(AccordionContent, { className: "p-4", children: /* @__PURE__ */ jsx(Renderer, { value: liveClass.class_note }) })
        ] }) })
      ] }, liveClass.id);
    }) })
  ] }) });
};
export {
  LiveClass as default
};
